"use client"
import { useParams } from 'next/navigation';
import React, { useState } from 'react';

const roleMapping = {
 
  'Sales': 3,
  'Admin': 2,
  'Marketing': 4,
 
};

const AddUserModal = () => {
    const { companyid,brandId } = useParams();
    
    
    
    
  const [showModal, setShowModal] = useState(false);
  const [formData, setFormData] = useState({
    company_id:companyid,
    brand_id: brandId,
    name: '',
    pseudonym: '',
    email: '',
    password: '',
    status: '',
    designation: '',
    role_name: '',
    canCreateUsers: 0,
    canCreateBrand: 0,
    hrm_id:''
  });
   

  const handleChange = (e) => {
    const { name, value } = e.target;

    setFormData({
      ...formData,
      [name]: name === "brand_id" ? parseInt(value, 10) : value, // Convert brandid to integer
    });
    
  };

  const handleSubmit = async (e) => {
    e.preventDefault();
    // Convert role_name to role_id
    const role_id = roleMapping[formData.role_name];
    if (role_id === undefined) {
      alert('Invalid role selected');
      return;
    }

    try {
      const response = await fetch(`${process.env.NEXT_PUBLIC_API_URL}/api/users`, {
        method: 'POST',
        headers: {
          'Content-Type': 'application/json',
        },
        body: JSON.stringify({ ...formData, role_id }),
      });

      if (response.ok) {
        // Handle successful submission
        // alert('User added successfully');
        setFormData({
          company_id: '',
          name: '',
          pseudonym: '',
          email: '',
          password: '',
          status: 1,
          role_name: '',
          hrm_id:''
        });
        setShowModal(false);
      } else {
        // Handle errors
        alert('Error adding user');
      }
    } catch (error) {
      console.error('Error:', error);
      alert('An error occurred');
    }
  };

  return (
    <div>
      <div className="container-fluid company-header">
        <div className="comp-header-row">
          <button className="btn" onClick={() => setShowModal(true)}>Add </button>
        </div>
      </div>

      {showModal && (
         <div className="modal-overlay-comp">
         <div className="modal-brand">
           <div className="modal-header-comp">
             <h5 className="modal-title">Add User</h5>
             <button
               type="button"
               className="modal-close"
               onClick={() => setModalOpen(false)}
             >
               &times;
             </button>
           </div>
           <div className="modal-body">
             <form onSubmit={handleSubmit}>
               <div className="form-group-row-2">
                 <div className="form-group">
                   <label htmlFor="name">Real Name:</label>
                   <input
                     className="form-control"
                     type="text"
                     id="name"
                     name="name"
                     value={formData.name}
                     onChange={handleChange}
                     required
                   />
                 </div>
                 <div className="form-group">
                   <label htmlFor="pseudonym">Pseudonym:</label>
                   <input
                     className="form-control"
                     type="text"
                     id="pseudonym"
                     name="pseudonym"
                     value={formData.pseudonym}
                     onChange={handleChange}
                     required
                   />
                 </div>
               </div>
               <div className="form-group-row-2">
                 <div className="form-group">
                   <label htmlFor="email">Email:</label>
                   <input
                     className="form-control"
                     type="email"
                     id="email"
                     name="email"
                     value={formData.email}
                     onChange={handleChange}
                     required
                   />
                 </div>
                 <div className="form-group">
                   <label htmlFor="password">Password:</label>
                   <input
                     className="form-control"
                     type="password"
                     id="password"
                     name="password"
                     value={formData.password}
                     onChange={handleChange}
                     required
                   />
                 </div>
               </div>
               <div className="form-group">
                 <label htmlFor="designation">Designation:</label>
                 <input
                   type="text"
                   className="form-control"
                   id="designation"
                   name="designation"
                   value={formData.designation}
                   onChange={handleChange}
                   required
                 />
               </div> <div className="form-group">
                 <label htmlFor="designation">HRM ID:</label>
                 <input
                   type="text"
                   className="form-control"
                   id="hrm_id"
                   name="hrm_id"
                   value={formData.hrm_id}
                   onChange={handleChange}
                   required
                 />
               </div>
               <div className="form-group">
                 <label htmlFor="status">Status:</label>
                 <select
                   className="form-control"
                   id="status"
                   name="status"
                   value={formData.status}
                   onChange={handleChange}
                   required
                 >
                   <option value="">Select a status</option>
                   <option value="1">Active</option>
                   <option value="0">Inactive</option>
                 </select>
               </div>
               <div className="form-group">
                 <label htmlFor="role_name">Role:</label>
                 <select
                   className="form-control"
                   id="role_name"
                   name="role_name"
                   value={formData.role_name}
                   onChange={handleChange}
                   required
                 >
                   <option value="">Select a role</option>
                 
                   <option value="Admin">Admin</option>
                   <option value="Sales" selected>Sales</option>
                   <option value="Marketing">Marketing</option>
                  
                 </select>
               </div>
               <div className="form-group">
               <label htmlFor="canCreateUsers">Can Create Users</label>
               <select
                 className="form-control"
                 id="canCreateUsers"
                 name="canCreateUsers"
                 value={formData.canCreateUsers}
                 onChange={handleChange}
                 required
               >
                 <option value={0}>No</option>
                 <option value={1}>Yes</option>
               </select>
             </div>
             <div className="form-group">
               <label htmlFor="canCreateBrand">Can Create Brand</label>
               <select
                 className="form-control"
                 id="canCreateBrand"
                 name="canCreateBrand"
                 value={formData.canCreateBrand}
                 onChange={handleChange}
                 required
               >
                 <option value={0}>No</option>
                 <option value={1}>Yes</option>
               </select>
             </div>
               <button type="submit" className="btn submit-btn p-btn mt-3 w-100">
                 Submit
               </button>
             </form>
           </div>
         </div>
       </div>
      )}
    </div>
  );
};

export default AddUserModal;
